﻿var timer = 0;
var portValue = 1;
var TD_NUM = 10;
var dispArr = new Array(new Array(), new Array(), new Array(), new Array());
var language;

function getPanelInfo()
{
 	var xmlhttp = getHTTPObject();
	var getParams = "type=1&cmd=1&panelInfo=1";

	xmlhttp.open("POST", "/goform/formIPQAM", true);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);
	
	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			GetAlarmsTable(xmlhttp.responseText.slice(7, -8));
		}
	}
	xmlhttp.send(getParams);
}

function GetAlarmsTable(panel_info)
{
	var xmlhttp = getHTTPObject();
	var getParams = "type=1&cmd=1&alarmInfo=1&language=" + language;
	
	xmlhttp.open("POST", "/goform/formIPQAM", true);
	if((bd.browser != "IE") && (language == 1))
	{
		xmlhttp.overrideMimeType("text/html;charset=gb2312");
	}
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	xmlhttp.setRequestHeader("Content-length", getParams.length);

	xmlhttp.onreadystatechange = function()
	{
		if(xmlhttp.readyState == 4)
		{
			var alarm_info;
			if((bd.browser == "IE") && (language == 1))
			{
				alarm_info = gb2utf8(xmlhttp.responseBody);
				var index = alarm_info.indexOf("</html>");
				var bias = alarm_info.length - index;
				alarm_info = alarm_info.slice(7, - bias);
			}
			else
			{
				alarm_info = xmlhttp.responseText.slice(7, -8);

			}
			
			if((panel_info != "") && (alarm_info != ""))
			{
//				var bw_values = bw_info.split("&");

//				displayBandwidths(bw_info);
				FillAlarmTable(alarm_info);
				// the rear panel information is in row 58 of the bandwidth information
				updateRearPanel(alarm_info, panel_info);
			}
			clearTimeout(timer);
			timer = setTimeout("getPanelInfo()", 5000);
		}
	}
	xmlhttp.send(getParams);
}

function updateRearPanel(alarm_info, panel_info)
{
	// AlarmInfo contains the following: date/time, severity, description, type, instance
	// we will take last 2 items and use them to determine if any of the rear panel
	// graphics needs to be updated
	//
	// bw_data contains the information about the rear panel items status
	//
	// we"ll start by putting the appropriate graphic up based on whether the item is
	// present or absent. Then, we"ll update each item based on the current alarms
	var card_info = panel_info.split("#");
	var len = card_info.length;
	var strTip;
	for(var i = 0; i < len - 1; i++)
	{
		var card = i + 1;
		var td = 0;
		if(card_info[i] == "NULL")
		{
			for(var j = 0; j < TD_NUM; j++)
			{
				td = j + 1;
				document.getElementById("Card" + card + "_" + td).style.display = "none";
			}
			document.getElementById("Card" + card + "Err").style.display = "none";
			document.getElementById("Card" + card + "No").style.display = "";
			if(language == 0)
			{
				strTip = "Card " + card + " - Absent";
			}
			else
			{
				strTip = "卡" + card + " - 未插卡";
			}
			document.getElementById("Card" + card + "No").title = strTip;
			document.getElementById("Card" + card + "No").style.cursor = "auto";
		}
		else if(card_info[i] == "ERROR")
		{
			for(var j = 0; j < TD_NUM; j++)
			{
				td = j + 1;
				document.getElementById("Card" + card + "_" + td).style.display = "none";
			}
			document.getElementById("Card" + card + "No").style.display = "none";
			document.getElementById("Card" + card + "Err").style.display = "";
			if(language == 0)
			{
				strTip = "Card " + card + " - Error";
			}
			else
			{
				strTip = "卡" + card + " - 错误";
			}
			document.getElementById("Card" + card + "Err").title = strTip;
			document.getElementById("Card" + card + "Err").style.cursor = "auto";
		}
		else
		{
			document.getElementById("Card" + card + "No").style.display = "none";
			document.getElementById("Card" + card + "Err").style.display = "none";
			
			for(var j = 0; j < TD_NUM; j++)
			{
				td = j + 1;
				document.getElementById("Card" + card + "_" + td).style.display = "";
			}
			var td_info = card_info[i].split("&");
			for(var j = 0; j < TD_NUM; j++)
			{
				td = j + 1;
				if(td_info[j] == "NULL")
				{
					document.getElementById("Card" + card + "_" + td).src = "../images/Td_Blank.png";
					document.getElementById("Card" + card + "_" + td).style.cursor = "auto";
				}
				else
				{
					document.getElementById("Card" + card + "_" + td).style.cursor = "pointer";
					var td_value = td_info[j].split(",");
					var type = td_value[0];
					var num = td_value[1];
					var value = td_value[2];
					dispArr[i][j] = type + "," + num; 
					if(type == "1")
					{
						if(value == "1")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/RFPort_Green.png";
							if(language == 0)
							{
								strTip = "RF Port " + card + "/" + num + " - OK";
							}
							else
							{
								strTip = "RF端口" + card + "/" + num + " - 正常";
							}
						}
						else if(value == "2")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/RFPort_Red.png";
							if(language == 0)
							{
								strTip = "RF Port " + card + "/" + num + " - Error";
							}
							else
							{
								strTip = "RF端口" + card + "/" + num + " - 错误";
							}
						}
						document.getElementById("Card" + card + "_" + td).title = strTip;
					}
					else if(type == "2")
					{
						if(value == "0")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/Ethernet_Blank.png";
							if(language == 0)
							{
								strTip = "GbE " + card + "/" + num + " - Absent";
							}
							else
							{
								strTip = "GbE " + card + "/" + num + " - 光/电模块缺失";
							}
						}
						else if(value == "1")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/Ethernet_Green.png";
							if(language == 0)
							{
								strTip = "GbE " + card + "/" + num + " - Up";
							}
							else
							{
								strTip = "GbE " + card + "/" + num + " - 正常";
							}
						}
						else if(value == "2")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/Ethernet_Red.png";
							if(language == 0)
							{
								strTip = "GbE " + card + "/" + num + " - Down";
							}
							else
							{
								strTip = "GbE " + card + "/" + num + " - 错误";
							}
						}
						else if(value == "3")
						{
							document.getElementById("Card" + card + "_" + td).src = "../images/Ethernet_Grey.png";
							if(language == 0)
							{
								strTip = "GbE " + card + "/" + num + " - No link";
							}
							else
							{
								strTip = "GbE " + card + "/" + num + " - 未连接";
							}
						}
						document.getElementById("Card" + card + "_" + td).title = strTip;
					}
				}
			}
		}
	}
	
	var other_info = card_info[len - 1].split(",");
	
	/* For DTI Port 1*/	
	if(other_info[0] == "Yes")
	{
		if(other_info[1] == "1")
		{
			document.getElementById("DTI1").src = "../images/Inter_Green_Left.png";
			if(language == 0)
			{
				document.getElementById("DTI1").title = "DTI Port 1 - OK";
			}
			else
			{
				document.getElementById("DTI1").title = "DTI端口1 - 正常";
			}
		}
		else if(other_info[1] == "2")
		{
			document.getElementById("DTI1").src = "../images/Inter_Red_Left.png";
			if(language == 0)
			{
				document.getElementById("DTI1").title = "DTI Port 1 - Not OK";
			}
			else
			{
				document.getElementById("DTI1").title = "DTI端口1 - 错误";
			}
		}
	}
	else if(other_info[0] == "No")
	{
		document.getElementById("DTI1").src = "../images/Inter_Grey_Left.png";
		if(language == 0)
		{
			document.getElementById("DTI1").title = "DTI Port 1 - No Link";
		}
		else
		{
			document.getElementById("DTI1").title = "DTI端口1 - 未连接";
		}
	}
	
	/* For DTI Port 2*/	
	if(other_info[2] == "Yes")
	{
		if(other_info[3] == "1")
		{
			document.getElementById("DTI2").src = "../images/Inter_Green_Right.png";
			if(language == 0)
			{
				document.getElementById("DTI2").title = "DTI Port 2 - OK";
			}
			else
			{
				document.getElementById("DTI2").title = "DTI端口2 - 正常";
			}
		}
		else if(other_info[3] == "2")
		{
			document.getElementById("DTI2").src = "../images/Inter_Red_Right.png";
			if(language == 0)
			{
				document.getElementById("DTI2").title = "DTI Port 2 - Not OK";
			}
			else
			{
				document.getElementById("DTI2").title = "DTI端口2 - 错误";
			}
		}
	}
	else if(other_info[3] == "No")
	{
		document.getElementById("DTI2").src = "../images/Inter_Grey_Right.png";
		if(language == 0)
		{
			document.getElementById("DTI2").title = "DTI Port 2 - No Link";
		}
		else
		{
			document.getElementById("DTI2").title = "DTI端口2 - 未连接";
		}
	}
	
	if(other_info[4] == "0")
	{
		document.getElementById("PS1").src = "../images/Power_Blank.png";
		if(language == 0)
		{
			strTip = "PSU 1 - Absent";
		}
		else
		{
			strTip = "电源1 - 模块缺失";
		}
		document.getElementById("PS1").title = strTip;
	}
	else if(other_info[4] == "1")
	{
		document.getElementById("PS1").src = "../images/Power_Green.png";
		if(language == 0)
		{
			strTip = "PSU 1 - OK";
		}
		else
		{
			strTip = "电源1 - 正常";
		}
		document.getElementById("PS1").title = strTip;
	}
	else if(other_info[4] == "2")
	{
		document.getElementById("PS1").src = "../images/Power_Red.png";
		if(language == 0)
		{
			strTip = "PSU 1 - Not OK";
		}
		else
		{
			strTip = "电源1 - 错误";
		}
		document.getElementById("PS1").title = strTip;
	}
	else if(other_info[4] == "3")
	{
		document.getElementById("PS1").src = "../images/Power_Grey.png";
		if(language == 0)
		{
			strTip = "PSU 1 - No Link";
		}
		else
		{
			strTip = "电源1 - 未连接";
		}
		document.getElementById("PS1").title = strTip;
	}

	if(other_info[5] == "0")
	{
		document.getElementById("PS2").src = "../images/Power_Blank.png";
		if(language == 0)
		{
			strTip = "PSU 2 - Absent";
		}
		else
		{
			strTip = "电源2 - 模块缺失";
		}
		document.getElementById("PS2").title = strTip;
	}
	else if(other_info[5] == "1")
	{
		document.getElementById("PS2").src = "../images/Power_Green.png";
		if(language == 0)
		{
			strTip = "PSU 2 - OK";
		}
		else
		{
			strTip = "电源2 - 正常";
		}
		document.getElementById("PS2").title = strTip;
	}
	else if(other_info[5] == "2")
	{
		document.getElementById("PS2").src = "../images/Power_Red.png";
		if(language == 0)
		{
			strTip = "PSU 2 - Not OK";
		}
		else
		{
			strTip = "电源2 - 错误";
		}
		document.getElementById("PS2").title = strTip;
	}
	else if(other_info[5] == "3")
	{
		document.getElementById("PS2").src = "../images/Power_Grey.png";
		if(language == 0)
		{
			strTip = "PSU 2 - No Link";
		}
		else
		{
			strTip = "电源2 - 未连接";
		}
		document.getElementById("PS2").title = strTip;
	}
	
	if(alarm_info != "No alarms")
	{
		var rows = alarm_info.split("&");
		var num_alarms = rows.length;

		if(num_alarms > 0)
		{
			var instance;
			var control_id;
			var displayInfo;
			var element;
			var response;
			var info;

			for(var i = num_alarms - 1; i >= 0; i--)
			{
				response = rows[i];
				info = response.split("|");
				if(info[0] != "NULL")
				{
					card = parseInt(info[0].split(",")[0]);
					td = parseInt(info[0].split(",")[1]);
				
					switch (parseInt(info[4]))
					{
						case 1: // FM_GBE_PORT_LINK
							instance = parseInt(info[5]);
							control_id = "Card" + card + "_" + td;
							element = document.getElementById(control_id);
							element.src = "../images/Ethernet_Red.png";
							if(language == 0)
							{
								element.title = "GbE " + card + "/" + instance + " - Link down";
							}
							else
							{
								element.title = "GbE " + card + "/" + instance + " - 连接错误";
							}
							break;
						case 2://FM_RF_LEVEL
							instance = parseInt(info[5]);
							control_id = "Card" + card + "_" + td;
							element = document.getElementById(control_id);
							element.src = "../images/RFPort_Red.png";
							if(language == 0)
							{
								element.title = "RF " + card + "/" + instance + " - Level error";
							}
							else
							{
								element.title = "RF " + card + "/" + instance + " - 电平异常";
							}
							break;
						case 3://FM_POWER_ERR
							instance = parseInt(info[5]);
							control_id = "PS" + instance;
							element = document.getElementById(control_id);
							element.src = "../images/Power_Red.png";
							if(language == 0)
							{
								element.title = control_id + " - Power error";
							}
							else
							{
								element.title = control_id + " - 电源错误";
							}
							break;
						default:
							break;
					}
				}
			}//for
		}//if
	}//if
}


var nRowInsertAfter = 0;
function alarm_table_add_row(AlarmCol)
{
	nRowInsertAfter++;

	var table = document.getElementById("ActiveAlarmTable");
	var nInsertAfterRow = nRowInsertAfter - 1;
	var row_style = AlarmCol[1]; // determine alarm style
	var row = table.insertRow(nInsertAfterRow);

	row.id = "rowIdBase" + (nRowInsertAfter);
	row.className = row_style;

///////////////////////////////////////////////////////////////////////
	var cellSeverity = row.insertCell(0);
	cellSeverity.id = "Severity" + (nInsertAfterRow);
	cellSeverity.style.width = "180px";
	cellSeverity.className = row_style;
	if(language == 0)
	{
		cellSeverity.innerHTML = AlarmCol[1];
	}
	else
	{
		cellSeverity.innerHTML = getAlarmSeveritCh(AlarmCol[1]);
	}

/////////////////////////////////////////////////////////////////////////

	var cellTime = row.insertCell(1);
	cellTime.id = "Time" + (nInsertAfterRow);
	cellTime.style.width = "250px";
	cellTime.className = row_style;
	cellTime.innerHTML = AlarmCol[2];

///////////////////////////////////////////////////////////////////////
// for the description, go to the 30th character, search backwards for
// the last space and then append an elipse
// then, we"ll add a link to the alarms page so that the user can get
// more information if they so desire
///////////////////////////////////////////////////////////////////////

	var cellDescription = row.insertCell(2);
	var a_Description = AlarmCol[3].substring(0,AlarmCol[3].lastIndexOf(" ",70));
	if(AlarmCol[3].length > 70)
	{
		a_Description = a_Description.concat("...");
	}
	cellDescription.id = "Description" + (nInsertAfterRow);
	cellDescription.className = row_style;
	if(language == 0)
	{
		cellDescription.innerHTML =
				"<a class='alarm' href='../asp/alarm_current.asp' onclick='dispAlarmsPage()'>" +
				a_Description +
				"</a>";
	}
	else
	{
		cellDescription.innerHTML =
				"<a class='alarm' href='../asp/alarm_current_cn.asp' onclick='dispAlarmsPage()'>" +
				a_Description +
				"</a>";
	}
	
}


// AlarmInfo contains the current list of alarms; an alarm has the following items:
//   severity, date/time, description, type, instance
function FillAlarmTable(AlarmInfo)
{
	var alarm_table = document.getElementById("ActiveAlarmTable");
	var alarm_rows = alarm_table.rows.length;
	var alarms = AlarmInfo.split("&");
	var i;

	// if there are no alarms, set the count to 0
	if(AlarmInfo == "No alarms")
	{
		alarm_count = 0;
	}
	else
	{
		alarm_count = alarms.length; // deduct 1 for the last "&"
	}

	// first thing to do is to see if the alarm count changed
	if(alarm_count < alarm_rows)
	{
		// delete the extra rows from the last row backwards
		for(i = (alarm_rows - 1); i >= alarm_count; i--)
		{
			alarm_table.deleteRow(i);
		}
		alarm_rows = alarm_count;
	}
	// debugging
	// document.getElementById("alarm_head2").innerHTML = "ar=" + alarm_rows + " ac=" + alarm_count;

	// we should now be left we enough rows in the alarm table to just do an
	// update of each existing row; if there are more alarms now than currently
	// in the table, we"ll add rows at the end to take care of it
	if(alarm_count > 0)
	{
		for(i = 0; i < alarm_rows; i++)
		{
			var response = alarms[i];
			var alarm_data = response.split("|");
			// debugging
			// document.getElementById("alarm_head1").innerHTML = "i=" + i;
			// document.getElementById("alarm_head3").innerHTML = alarm_data[2];
			var alarm_cells = alarm_table.rows[i].cells;
			var row_style = alarm_data[1];
			alarm_table.rows[i].className = row_style;
			var desc = alarm_data[3].substring(0,alarm_data[3].lastIndexOf(" ",70));
			
			if(language == 0)
			{
				alarm_cells[0].innerHTML = alarm_data[1];	// severity
			}
			else
			{
				alarm_cells[0].innerHTML = getAlarmSeveritCh(alarm_data[1]);	// severityCn
			}
			alarm_cells[0].className = row_style;
			alarm_cells[1].innerHTML = alarm_data[2];	// date/time
			alarm_cells[1].className = row_style;
			if(alarm_data[2].length > 70)
			{
				desc = desc.concat("...");
			}
			if(language == 0)
			{
				alarm_cells[2].innerHTML =
						"<a class='alarm' href='/asp/alarm_current.asp' onclick='dispAlarmsPage()'>" +
						desc +
						"</a>"; // description
			}
			else
			{
				alarm_cells[2].innerHTML =
						"<a class='alarm' href='/asp/alarm_current_cn.asp' onclick='dispAlarmsPage()'>" +
						desc +
						"</a>"; // description
			}
			alarm_cells[2].className = row_style;
			
		}
		nRowInsertAfter = alarm_rows;
	}
	if(alarm_count > alarm_rows)
	{
		for(i = alarm_rows; i < alarm_count; i++)
		{
			var response = alarms[i];
			var alarm_data = response.split("|");

			alarm_table_add_row(alarm_data);
		}
	}
}

function dispAlarmsPage()
{
	javascript:parent.imageClickFlag = 1;
	javascript:parent.onChangeTab('menu-alarms');
}

function dispPage(card, td)
{
	var type = parseInt(dispArr[card][td].split(",")[0]);
	var num = parseInt(dispArr[card][td].split(",")[1]);
	if(type == "1")//rf
	{
		javascript:parent.imageClickFlag = (card + 2) * 100 + 20 + num;
	}
	else if(type == "2")//gbe
	{
		javascript:parent.imageClickFlag = (card + 2) * 100 + 10 + num;
	}
	javascript:parent.onChangeTab('menu-monitor');
}

function dispIPConfigPage()
{
	javascript:parent.imageClickFlag = 13;
	javascript:parent.onChangeTab('menu-system');
}

function dispDTIMonitorPage()
{
	javascript:parent.imageClickFlag = 4;
	javascript:parent.onChangeTab('menu-monitor');
}

function dispTemperaturePage()
{
	javascript:parent.imageClickFlag = 11;
	javascript:parent.onChangeTab('menu-system');
}

window.onload = function()
{
	language = document.getElementById("language").value;
	getPanelInfo();
}
